set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 6, panel F

**1. Preparing data
use $path_in\KLEMS_2017_clean, clear
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	drop if D1_LP1_EMP==.

	*Standardize TFP 
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	

	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
		
*Table 6, panel F
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T6_$col
				lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
				est restore T6_$col
	end		
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"

	**Column 1: Employment
		global col=1
		qui areg D1_lnEMP  `own' [w=weight_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Column 2: Hours worked
		global col=2
		qui areg D1_lnH_EMP  `own' [w=weight_h_c], absorb(ct) clus(ic) 
			storeestimates

	**Column 4: Nominal wage bill
		global col=3
		qui areg D1_lnLAB  `own' [w=weight_h_c], absorb(ct) clus(ic) 
			storeestimates

	**Column 5: Nominal value added
		global col=4
		qui areg D1_lnVA  `own' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
				
	**Column 6: Real value added
		global col=5
		qui areg D1_lnVA_QI  `own' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates

	**Column 8: Laborshare
		global col=6
		qui areg D1_lnlaborshare  `own' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
			
	*Table
	esttab T6_1 T6_2 T6_3 T6_4 T6_5 T6_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel F")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel F")
		}					
